#!/usr/bin/perl

# trivial-index.pl - index a couple of documents with solr/lucene

# Eric Lease Morgan <eric_morgan@infomotions.com>
# December 31, 2008 - first cut


# define
use constant SOLR => 'http://localhost:210/solr';
use constant DATA => ( 'Hello, World!', 'It is nice to meet you.' );

# require
use strict;
use WebService::Solr;

# initialize
my $solr = WebService::Solr->new( SOLR );

# process each data item
my $index = 0;
foreach ( DATA ) {

# increment
$index++;
 
# populate solr fields
my $id  = WebService::Solr::Field->new( id  => $index );
my $title = WebService::Solr::Field->new( title => $_ );

# fill a document with the fields
my $doc = WebService::Solr::Document->new;
$doc->add_fields(( $id, $title ));

# save
$solr->add( $doc );
$solr->commit;

}

# done
exit;
